#ifndef _CVECTOR_H_
#define _CVECTOR_H_

#include "global.h"
#include <math.h>

//-----------------------------------------------------------------------------
// A point or vector in 3-dimensional space

class cVector
{
public:
  cVector();                                       // default ctor
  cVector(float initX, float initY, float initZ);  // ctor with initialisation
  cVector(const cVector& v);                       // copy ctor
  ~cVector();

  float x, y, z;                                   // X, Y and Z coordinates

  cVector operator+ (const cVector& other) const;  // vector sum
  cVector operator- (const cVector& other) const;  // vector difference
  cVector operator* (float factor) const;          // linear product
  cVector operator/ (float factor) const;          // linear division

  void Normalize();                                // scale to unit length

  float Inner(const cVector& other) const;         // inner product (dot product)
  cVector Outer(const cVector& other) const;       // outer product (cross product)

  inline float Length() const { return sqrt(x*x + y*y + z*z); }
  inline float SquareLength() const { return x*x + y*y + z*z; }

  static bool Center(const cVector& a, const cVector& b, const cVector& c, cVector& center);
};

#endif
