#ifndef _CTOOLBAR_H_
#define _CTOOLBAR_H_

#include "global.h"
#include "ceventredirector.h"
#include <wx/toolbar.h>

class wxRegConfig;

//-----------------------------------------------------------------------------
// Base class for the toolbars

class cToolbar : public wxToolBar, public cEventRedirector
{
private:
  bool m_ShouldBeHidden;    // is the toolbar (supposed to be) hidden?

  DECLARE_EVENT_TABLE()

protected:
  bool m_Tooltips;          // enable tooltips?

public:
  cToolbar(wxWindow* parent, long style = 0);
  virtual ~cToolbar();

  inline bool ShouldBeHidden() const { return m_ShouldBeHidden; }
  inline void SetShouldBeHidden(bool hidden) { m_ShouldBeHidden = hidden; }

  virtual void TranslateTexts() = 0;

  void EnableToolTips(bool flag);

  virtual void UpdateAll() {}
  virtual void DoSetTrackCursorPos(cGraphView* WXUNUSED(view), float WXUNUSED(distance), int WXUNUSED(type)) {}
  virtual void DoSetTrackSelection(float WXUNUSED(start), float WXUNUSED(end)) {}

  virtual void LoadConfig(wxRegConfig* WXUNUSED(config), const wxString& WXUNUSED(key)) {}
  virtual void SaveConfig(wxRegConfig* WXUNUSED(config), const wxString& WXUNUSED(key)) {}
};

#endif
