#ifndef _CGRAPH_H_H_
#define _CGRAPH_H_H_

#include "global.h"
#include "cgraph.h"
#include <wx/menu.h>

//-----------------------------------------------------------------------------
// A graph

class cGraphH : public cGraph
{
private:
  int m_BinCount;          // the number of bins

  cLap* m_Lap;             // the (only) lap whose curve must be plotted

  // graph contents
  int m_Logtype;           // type of log-data to be shown
  int m_Wheel;            // type of wheel for which the data must be shown

  // event handlers
  void OnMouseMove(wxMouseEvent& event);
  void OnMouseEntering(wxMouseEvent& event);
  void OnMouseLeaving(wxMouseEvent& event);
  void OnPaint(wxPaintEvent& event);

  DECLARE_EVENT_TABLE()

protected:
  virtual void OnAdjustBbox();

  virtual float GetSelectionStart() { return m_SelStart; }
  virtual float GetSelectionEnd() { return m_SelEnd; }

  virtual rbbmode_t GetRbbMode(wxMouseEvent& event);

public:
  cGraphH(cGraphView* parent);
  virtual ~cGraphH();

  // manage the set of curves
  virtual void AddCurve(cLap* lap);
  virtual void DeleteCurve(cLap* lap);
  virtual void DeleteAllCurves();

  virtual bool IsIntegerX() { return cCarState::IsInteger(m_Logtype); }
  virtual bool IsIntegerY() { return false; }

  int GetBins() const { return m_BinCount; }
  void SetBins(int bins);

  int GetLogtype() const { return m_Logtype; }
  int GetWheeltype() const { return m_Wheel; }
  void SetLogtype(int log, int wheel);

  void SetLap(cLap* lap);
  cLap* GetLap() const { CHECK_PTR_NULL(m_Lap); return m_Lap; }

  virtual void DoSetTrackSelection(float start, float end);
  virtual void DoSetTrackCursorPos(
      cGraphView* WXUNUSED(view), float WXUNUSED(distance), int WXUNUSED(type)) {}

  virtual void DoSync();
  virtual void DoSynchronise(cGraph* graph);

  virtual wxString SaveSettings() const;
  virtual void LoadSettings(const wxString& settings);

  virtual wxString GetUnitsX() { return cCarState::GetLogtypeUnits(m_Logtype); }
  virtual wxString GetUnitsY() { return wxString(_T("%")); }
};

#endif
