#ifndef _CCURVE_H_
#define _CCURVE_H_

#include "global.h"
#include "clap.h"
#include <wx/pen.h>
#include <wx/dc.h>

class cGraph;

// default for the maxPoints parameter in cCurve::Rewind
#define MAX_REWIND_POINTS 10000

//-----------------------------------------------------------------------------
// Base class for a curve in a graph

class cCurve
{
protected:
  float m_MinX, m_MaxX, m_MinY, m_MaxY; // global bounding box (inclusive)

  wxPen m_Pen;    // the curve's pen
  bool m_Connect; // is the curve a connectd line? (or separate dots?)
  cLap* m_Lap;    // lap containing the curve's base data
  bool m_Shown;   // can this curve be shown on the graph?

public:
  ENABLE_OBJCHECKER

  cCurve(cLap* lap);
  virtual ~cCurve();

  cLap* GetLap() const { return m_Lap; }
  bool IsShown() const { return m_Shown && m_Lap->IsShown(); }
  void Show(bool show) { m_Shown = show; }
  bool GetConnect() const { return m_Connect; }
  wxPen GetPen() const { return m_Pen; }
  void SetConnect(bool connect) { m_Connect = connect; }

  // get borders of bounding box
  virtual float GetMinX() { return m_MinX; }
  virtual float GetMaxX() { return m_MaxX; }
  virtual float GetMinY() { return m_MinY; }
  virtual float GetMaxY() { return m_MaxY; }

  virtual void Rewind(float WXUNUSED(start), float WXUNUSED(end), size_t WXUNUSED(maxPoints)) {}
  virtual bool GetNextPoint(float& WXUNUSED(x), float& WXUNUSED(y)) { return false; }
  virtual bool GetValueAt(float WXUNUSED(distance), float& WXUNUSED(x), float& WXUNUSED(y)) { return false; }

  virtual void Plot(wxDC& dc, cGraph& graph, float start, float end);

  void GetBbox(float start, float end, float& minX, float& maxX, float& minY, float& maxY);
  virtual void AdjustBbox();
};

WX_DECLARE_OBJARRAY(cCurve, cCurveArray);

#endif
