#ifndef _CCSVDLG_H_
#define _CCSVDLG_H_

#include "global.h"
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/choice.h>
#include <wx/button.h>
#include <wx/stattext.h>
#include <wx/checkbox.h>

class wxRegConfig;

//-----------------------------------------------------------------------------
// The CSV export setting dialog

class cCsvDlg : public wxDialog
{
private:
  wxString m_DecSep;                // the decimal separator character
  wxString m_FieldWrap;             // the field-wrap character
  bool m_HeaderLine;                // 1st line is header line with column names?

  wxStaticText* m_DecSepText;
  wxChoice* m_DecSepChoice;
  wxChoice* m_FieldWrapChoice;
  wxCheckBox* m_FieldWrapCheck;
  wxCheckBox* m_HeaderLineCheck;
  wxButton* m_OkBtn;                // "OK" button
  wxButton* m_CancelBtn;            // "Cancel" button

  wxBoxSizer* m_DecSepSizer;        // sizer for choosing the decimal separator
  wxBoxSizer* m_FieldWrapSizer;     // sizer for choosing the field-wrap character
  wxBoxSizer* m_ButtonSizer;        // sizer for the OK/Cancel buttons
  wxBoxSizer* m_TopSizer;           // top-level sizer

  void EnableButtons();

  void OnButton(wxCommandEvent& event);
  void OnCheckBox(wxCommandEvent& WXUNUSED(event)) { EnableButtons(); }

  void DoEnter();

  DECLARE_EVENT_TABLE()

public:
  cCsvDlg(wxWindow* parent);
  virtual ~cCsvDlg();

  int DoShowModal();

  wxString GetDecimalSeparator() const { return m_DecSep; }
  wxString GetFieldWrapCharacter() const { return m_FieldWrap; }
  bool GetHeaderLine() const { return m_HeaderLine; }

  virtual void TranslateTexts();

  virtual void LoadConfig(wxRegConfig* config, const wxString& key);
  virtual void SaveConfig(wxRegConfig* config, const wxString& key);
};

#endif
