#ifndef _CAPP_H_
#define _CAPP_H_

#include "global.h"
#include "cdde.h"
#include <wx/app.h>
#include <wx/config.h>
#include <wx/snglinst.h>

class cMainFrame;
class cCsvDlg;

//-----------------------------------------------------------------------------
// The single application object

class cApp : public wxApp
{
private:
  cMainFrame* m_Frame;                // the main frame
  wxConfig* m_Config;                 // the application config file
  wxString m_AppFolder;               // the directory of the application executable

  wxString m_ExportFolder;            // current directory for exporting lap data to CSV
  cCsvDlg* m_CsvSettings;             // the object that holds the settings for CSV export

  wxSingleInstanceChecker* m_Checker; // the object to check for other instances of the application
  cDDEServer m_DDEServer;             // the server object to receive DDE commands

  void SetAppFolder();

public:
  virtual bool OnInit();
  virtual int OnExit();

  cMainFrame* GetFrame() { return m_Frame; }
  wxConfig* GetConfig() { return m_Config; }
  wxString GetAppFolder() const { return m_AppFolder; }

  wxString GetExportFolder() const { return m_ExportFolder; }
  void SetExportFolder(const wxString& folder) { m_ExportFolder = folder; }

  const cCsvDlg* GetCsvSettings() const { return m_CsvSettings; }
  void SetCsvSettings(cCsvDlg* settings) { m_CsvSettings = settings; }
};

#endif
