"""Example 2: Receiving packets

We hook up an event-handler to receive all IS_MSO message packets, and print 
out the contents of each one that is received.

"""

import pyinsim

# Print out all messages typed into the game chat.
def messageReceived(insim, mso):
    print 'Message:', mso.Msg
    
# Create new InSim object.
insim = pyinsim.InSim()

# Bind event-handler for IS_MSO packets.
insim.bind(pyinsim.ISP_MSO, messageReceived)

# Initialise InSim
try:
    insim.init('localhost', 29999, IName='^3Example 2')
except pyinsim.Error as err:
    print 'InSim Error:', err