"""Example 2: Handling pyinsim events

Bind event-handlers for the EVT_CONNECTED, EVT_CLOSED and EVT_ERROR events.

"""

import pyinsim

# Print out the hostaddr pair
def connected(insim, hostaddr):
    print 'Connected to host %s:%d' % (hostaddr[0], hostaddr[1])
    
# Print the reason for closing.
def closed(insim, reason):
    if reason == pyinsim.CLOSE_LOST:
        print 'Lost connection with LFS'
    elif reason == pyinsim.CLOSE_REQUEST:
        print 'InSim connection closed by request'
        
# Print the exception message.
def error(insim, err):
    print 'InSim error on internal receive thread: ', err

# Create new InSim object.
insim = pyinsim.InSim()

# Bind pyinsim events.
insim.bind(pyinsim.EVT_CONNECTED, connected)
insim.bind(pyinsim.EVT_CLOSED, closed)
insim.bind(pyinsim.EVT_ERROR, error)

# Initialise InSim.
try:
    insim.init('localhost', 29999, IName='^3Example 3')    
except pyinsim.Error as err:
    print 'InSim Error:', err