"""Example 8: OutGauge

Simple example that receives OutGauge packets and checks the shift-light and 
pitlane speed limiter flags.

"""
import pyinsim

def outgauge(out, og):
    # Check shift-light flag.
    if og.ShowLights & pyinsim.DL_SHIFT:
        print 'Shift-light on'
    # Check pitlane speed limiter flag.
    if og.ShowLights & pyinsim.DL_PITSPEED:
        print 'Pitland speed limiter on'

# Event-handler called if OutGauge times out.
def timeout(out, timeout):
    print 'OutGauged timed out in', timeout, 'seconds'
    
# Initialise OutGauge object and bind events.
out = pyinsim.OutGauge()
out.bind(pyinsim.OUT_OUTGAUGE, outgauge)
out.bind(pyinsim.EVT_TIMEOUT, timeout)

try:
    # Start OutGauge listener, with a timeout of 30 seconds.
    out.init('localhost', 30000, 30.0)
except pyinsim.Error, err:
    print 'OutGauge Error:', err
    