"""Example 5: MCI updates (and UDP)

This example monitors the speed of each car on track and spectates any player 
who exceeds 80 Kph. This example also demonstrates using a seperate UDP port
to receive MCI or NLP updates.

"""

import pyinsim

# Dict to store players.
players = {}

# Add player to the dict.
def playerJoined(insim, npl):
    players[npl.PLID] = npl
    
# Remove player from dict.
def playerLeft(insim, pll):
    del players[pll.PLID]

# Spectate all players who exceeds 80 Kph speed.
def carUpdate(insim, mci):
    # Loop through all cars in MCI packet.
    for car in mci.CompCars:
        # Get player from dict.
        npl = players[car.PLID]
        # Convert speed into Kph.
        kph = pyinsim.kph(car.Speed)
        # Check speed and send spectate message.
        if kph > 80:
            insim.sendm('/spec %s' % npl.PName)
            insim.sendm('%s ^3spectated for speeding' % npl.PName)
        
# Create InSim object and bind events.
insim = pyinsim.InSim()
insim.bind(pyinsim.ISP_NPL, playerJoined)
insim.bind(pyinsim.ISP_PLL, playerLeft)
insim.bind(pyinsim.ISP_MCI, carUpdate)

# Initialise InSim to send MCI packets every 500 milliseconds on UDP port 30000.
try:
    insim.init('localhost', 29999, IName='^3Example 5', UDPPort=30000, 
               Flags=pyinsim.ISF_MCI, Interval=500)
    
    # Request for all players to be sent.
    insim.send(pyinsim.ISP_TINY, ReqI=1, SubT=pyinsim.TINY_NPL)
    
except pyinsim.Error as err:
    print 'InSim Error:', err