"""Example 13: InSim Relay

This example demonstrates how to use InSim Relay. We connect to the relay, 
request a list of hosts, select a random one, and then print out its 
connection list.

"""

import pyinsim
import random

# List of hosts.
hosts = []

# Check if host is populated and does not require a spectator pass, then
# add to hosts list.
def hostList(isr, hos):
    global hosts
    for host in hos.Hosts:
        if host.NumConns > 1 and not host.Flags & pyinsim.HOS_SPECPASS:
            hosts.append(host.HName)

# Print out the error message.
def relayError(isr, err):
    print 'InSim Relay error:', err.ErrNo

# Print out the name and UCID of the connection.
def newConn(isr, ncn):
    print 'New connection, UName %s (%d)' % (ncn.UName, ncn.UCID)

# Request for all connections to be sent.
def requestConns(isr):
    isr.send(pyinsim.ISP_TINY, SubT=pyinsim.TINY_NCN, ReqI=1)

# Request for all hosts to be sent.
def selectHost(isr):
    host = pyinsim.stripCols(random.choice(hosts))
    print 'Selecting host:', host
    isr.send(pyinsim.IRP_SEL, HName=host)
    
    # Request connections after 2 seconds.
    isr.timer(requestConns, 2)

# Create new InSimRelay object and bind events.
isr = pyinsim.InSimRelay()
isr.bind(pyinsim.IRP_HOS, hostList)
isr.bind(pyinsim.IRP_ERR, relayError)
isr.bind(pyinsim.ISP_NCN, newConn)

try:
    # Initialise InSimRelay.
    isr.init()
    
    # Request host list.
    isr.send(pyinsim.IRP_HLR)
    
    # Select host after 5 seconds.
    isr.timer(selectHost, 5)
    
except pyinsim.Error as err:
    print 'Error:', err
    