"""Example 3: Managing player and connection lists

"""

import pyinsim

# Dict to store player and connection lists.
connections = {}
players = {}

# Add connection to the list.
def connectionJoined(insim, ncn):
    connections[ncn.UCID] = ncn

# Remove connection from the list.
def connectionLeft(insim, cnl):
    del connections[cnl.UCID]

# Add player to the list.
def playerJoined(insim, npl):
    players[npl.PLID] = npl

# Remove player from the list.
def playerLeft(insim, pll):
    del players[pll.PLID]

# Request for all players and connections to be sent.
def joinedMultiplayer(insim, ism):
    insim.send(pyinsim.ISP_TINY, ReqI=1, SubT=pyinsim.TINY_NCN)
    insim.send(pyinsim.ISP_TINY, ReqI=1, SubT=pyinsim.TINY_NPL)

# Create new InSim object.
insim = pyinsim.InSim()

# Bind packet events.
insim.bind(pyinsim.ISP_NCN, connectionJoined)
insim.bind(pyinsim.ISP_CNL, connectionLeft)
insim.bind(pyinsim.ISP_NPL, playerJoined)
insim.bind(pyinsim.ISP_PLL, playerLeft)
insim.bind(pyinsim.ISP_ISM, joinedMultiplayer)

# Initialise InSim.
try:
    insim.init('localhost', 29999, IName='^3Example 4')
except pyinsim.Error as err:
    print 'InSim Error:', err
    