"""Example 9: OutGauge through Insim

This example demonstrates reciving both InSim and OutGauge packets. It prints
out how much fuel the currently viewed driver has. This does not work if you
are viewing other players on a host, as fuel info is not sent for them.

"""

import pyinsim

plid = 0
players = {}

# Print out the name of the viewed driver and their fuel percentage.
def outgauge(insim, og):
    npl = players[plid]
    fuel = og.Fuel * 100 # Convert into percent
    print '%s has %.2f%% fuel' % (npl.PName, fuel)
    
# Update viewed PLID when viewed driver changes.
def statechanged(insim, sta):
    global plid
    plid = sta.ViewPLID
    
# Add to players dict.
def playerjoined(insim, npl):
    players[npl.PLID] = npl
    
# Delete from players dict.
def playerleft(insim, pll):
    del players[pll.PLID]

# Create InSim object.
insim = pyinsim.InSim()

# Bind events.
insim.bind(pyinsim.OUT_OUTGAUGE, outgauge)
insim.bind(pyinsim.ISP_STA, statechanged)
insim.bind(pyinsim.ISP_NPL, playerjoined)
insim.bind(pyinsim.ISP_PLL, playerleft)

try:
    # Initialise InSim with UDP on port 30000
    insim.init('localhost', 29999, UDPPort=30000, IName='^3Example 9')
    
    # Request all NPL packets to be sent.
    insim.send(pyinsim.ISP_TINY, ReqI=1, SubT=pyinsim.TINY_NPL)
    
    # Initialise OutGauge packets to be sent at 500 millisecond intervals.
    insim.send(pyinsim.ISP_SMALL, ReqI=1, SubT=pyinsim.SMALL_SSG, UVal=500)
except pyinsim.Error as err:
    print 'InSim Error:', err
    