"""Example 6: InSim buttons.

We display buttons on the screen and print out a message when they are
clicked.

"""

import pyinsim

# Constants for button ClickIDs.
ID_BUTTON1 = 1
ID_BUTTON2 = 2
ID_BUTTON3 = 3

# Button click event-handler.
def buttonClick(insim, btc):
    # Check which button was clicked.
    if btc.ClickID == ID_BUTTON1:
        print 'Button 1 clicked!'
    elif btc.ClickID == ID_BUTTON2:
        print 'Button 2 clicked!'
    
# Button text event-handler.
def buttonTextEntered(insim, btt):
    # Check which button was clicked.
    if btt.ClickID == ID_BUTTON3:
        # Print out the text the user typed.
        print 'Button 3: %s' % btt.Text
    
insim = pyinsim.InSim()

# Bind events.
insim.bind(pyinsim.ISP_BTC, buttonClick)
insim.bind(pyinsim.ISP_BTT, buttonTextEntered)

try:
    # Set Flags to LOCAL as these buttons are being sent to a local LFS client 
    # and not a host.
    insim.init('localhost', 29999, IName='^3Example 6', Flags=pyinsim.ISF_LOCAL)

    # Send button 1 to InSim.
    insim.send(pyinsim.ISP_BTN, ReqI=1, UCID=0, ClickID=ID_BUTTON1, 
               BStyle=pyinsim.ISB_DARK|pyinsim.ISB_CLICK, T=35, L=5, W=20, H=8,
               Text='Button 1')
               
    # Send button 2 to InSim.
    insim.send(pyinsim.ISP_BTN, ReqI=1, UCID=0, ClickID=ID_BUTTON2, 
               BStyle=pyinsim.ISB_DARK|pyinsim.ISB_CLICK, T=45, L=5, W=20, H=8,
               Text='Button 2')  

    # Send button 3 to InSim, which allows the user to enter text.
    insim.send(pyinsim.ISP_BTN, ReqI=1, UCID=0, ClickID=ID_BUTTON3, 
               BStyle=pyinsim.ISB_DARK|pyinsim.ISB_CLICK, T=55, L=5, W=20, H=8,
               TypeIn=64, Text='Button 3')  

except pyinsim.Error, err:
    print 'InSim Error:', err