﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace InSimTutorial
{
    /// <summary>
    /// Class to manage TCP receive buffer.
    /// </summary>
    public class RecvBuffer
    {
        // Store buffer data in a generic list.
        private List<byte> buffer = new List<byte>();

        public void Append(byte[] data, int count)
        {
            // Add packet data to buffer.
            byte[] temp = new byte[count];
            Buffer.BlockCopy(data, 0, temp, 0, count);
            buffer.AddRange(temp);
        }

        public bool HasPackets()
        {
            return (buffer.Count > 0) && (buffer.Count >= buffer[0]);
        }

        public IEnumerable<byte[]> GetPackets()
        {
            while (HasPackets())
            {
                // The first byte of each packet is the size.
                int psize = buffer[0];

                // Copy packet from buffer.
                byte[] packet = new byte[psize];
                buffer.CopyTo(0, packet, 0, psize);

                // Remove copied packet from buffer.
                buffer.RemoveRange(0, psize);

                // Enumerate the packet.
                yield return packet;
            }
        }
    }
}
