﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace InSimTutorial
{
    /// <summary>
    /// VERsion
    /// </summary>
    public class IS_VER
    {
        public const byte Size = 20;			// 20
        public const PacketTypes Type = PacketTypes.ISP_VER;			// ISP_VERSION
        public byte ReqI;			// ReqI as received in the request packet
        public byte Zero;

        public string Version;//[8];		// LFS version, e.g. 0.3G
        public string Product;//[6];		// Product : DEMO or S1
        public ushort InSimVer;		// InSim Version : increased when InSim packets change

        public IS_VER(byte[] data)
        {
            ReqI = data[2];
            Zero = data[3];

            Version = ASCIIEncoding.ASCII.GetString(data, 4, 8);
            Product = ASCIIEncoding.ASCII.GetString(data, 12, 6);
            //InSimVer = (ushort)((data[18] << 8) | (data[19] & 0xff));
            InSimVer = BitConverter.ToUInt16(data, 18);
        }
    }
}
