﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace InSimTutorial
{
    /// <summary>
    /// Enum for IS_MSO UserType byte.
    /// </summary>
    public enum UserValues
    {
        MSO_SYSTEM,			// 0 - system message
        MSO_USER,			// 1 - normal visible user message
        MSO_PREFIX,			// 2 - hidden message starting with special prefix (see ISI)
        MSO_O,				// 3 - hidden message typed on local pc with /o command
        MSO_NUM
    }

    /// <summary>
    /// MSg Out - system messages and user messages 
    /// </summary>
    public class IS_MSO
    {
        public const byte Size = 136;		// 136
        public const PacketTypes Type = PacketTypes.ISP_MSO;		// ISP_MSO
        public byte ReqI;		// 0
        public byte Zero;

        public byte UCID;		// connection's unique id (0 = host)
        public byte PLID;		// player's unique id (if zero, use UCID)
        public UserValues UserType;	// set if typed by a user (see User Values below) 
        public byte TextStart;	// first character of the actual text (after player name)

        public string Msg;//[128];

        public IS_MSO(byte[] data)
        {
            ReqI = data[2];
            Zero = data[3];

            UCID = data[4];
            PLID = data[5];
            UserType = (UserValues)data[6];
            TextStart = data[7];

            Msg = ASCIIEncoding.ASCII.GetString(data, 8, 128);
        }
    }
}
