﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace InSimTutorial
{
    /// <summary>
    /// Bit flags for IS_ISI Flags.
    /// </summary>
    [Flags]
    public enum InSimFlags
    {
        ISF_RES_0 = 1,//		1	// bit 0 : spare
        ISF_RES_1 = 2,//		2	// bit 1 : spare
        ISF_LOCAL = 4,//		4	// bit 2 : guest or single player
        ISF_MSO_COLS  = 8,//   	8	// bit 3 : keep colours in MSO text
        ISF_NLP = 16,//			16	// bit 4 : receive NLP packets
        ISF_MCI = 32,//		    32	// bit 5 : receive MCI packets
    }

    /// <summary>
    /// InSim Init - packet to initialise the InSim system
    /// </summary>
    public class IS_ISI
    {
        public const byte Size = 44;
        public const PacketTypes Type = PacketTypes.ISP_ISI;
        public byte ReqI = 0;
        public ushort UDPPort = 0;
        public InSimFlags Flags = 0;
        public char Prefix = char.MinValue;
        public ushort Interval = 0;
        public string Admin = string.Empty;
        public string IName = string.Empty;

        public byte[] GetPacketData()
        {
            byte[] data = new byte[Size];

            //byte Size;		// 44
            data[0] = Size;
            //byte Type;		// ISP_ISI
            data[1] = (byte)Type;
            //byte ReqI;		// If non-zero LFS will send an IS_VER packet
            data[2] = ReqI;
            //byte Zero;		// 0
            data[3] = 0;

            //word	UDPPort;	// Port for UDP replies from LFS (0 to 65535)
            data[4] = (byte)(UDPPort & 0x00FF);
            data[5] = (byte)(UDPPort & 0xFF00 >> 8);
            //word	Flags;		// Bit flags for options (see below)
            data[6] = (byte)((byte)Flags & 0x00FF);
            data[7] = (byte)((byte)Flags & 0xFF00 >> 8);

            //byte	Sp0;		// 0
            data[8] = 0;
            //byte	Prefix;		// Special host message prefix character
            data[9] = (byte)Prefix;
            //word	Interval;	// Time in ms between NLP or MCI (0 = none)
            data[10] = (byte)(Interval & 0x00FF);
            data[11] = (byte)(Interval & 0xFF00 >> 8);

            //char	Admin[16];	// Admin password (if set in LFS)
            ASCIIEncoding.ASCII.GetBytes(Admin, 0, Admin.Length, data, 12);
            //char	IName[16];	// A short name for your program
            ASCIIEncoding.ASCII.GetBytes(IName, 0, IName.Length, data, 28);

            return data;
        }
    }
}
